package ftp;
import java.io.File;
import java.io.PrintStream;

public class CommandeCD extends Commande {
	
	public CommandeCD(PrintStream ps, String commandeStr) {
		super(ps, commandeStr);
	}

	public void execute() {
		
		// Si la commande n'a pas d'argument, envoyer un message d'erreur.
		if (commandeArgs.length == 0)
		{
			System.out.println("-> CD sans argument");
			ps.println("2 La commande doit contenir un chemin relatif.");
		}
		else
		{
			String newPath = commandeArgs[0];
			
			// $$ CommandExecutor.currentFile = new File(CommandExecutor.currentFile.getAbsolutePath().substring(0, CommandExecutor.currentFile.getAbsolutePath().length()-1) + newPath);
			
			// $$ System.out.println(CommandExecutor.currentFile.getAbsolutePath());
			
			// Sépare les répertoires du chemin dans un tableau.
			String[] splitPath = newPath.split("/");
			
			// $$ System.out.println("\nsplitPath :");
			
			File newCurrentFile = null;
			
			// Vrai si une réponse négative a été envoyée, faux sinon.
			Boolean rep2sent = false;
			
			for (String partPath : splitPath)
			{
				newCurrentFile = null;
				
				// $$ System.out.println("\n\n" + partPath + " :");
				
				// $$ System.out.println("{" + (s.equals(".")) + " ; " + (s.equals("..")) + " ; " + (s.equals("www")) + "}");
				
				
				if (partPath.equals("."))
				{
					// Obtention du répertoire courrant (= aucun changement).
					newCurrentFile = CommandExecutor.currentFile;
					// $$ System.out.println("1 .0 Rien");
				}
				else if (partPath.equals(".."))
				{
					// Obtention du parent.
					newCurrentFile = new File(CommandExecutor.currentFile.getAbsoluteFile().getParent());
					
					// Si le répertoire parent n'est pas dans le répertoire de l'utilisateur actif, newCurrentFile est remis à null.
					if(!newCurrentFile.getAbsolutePath().startsWith(CommandExecutor.homeDir.getAbsolutePath())) {				
						newCurrentFile = null;
					}else {
						// $$ System.out.println("1 .1 Accès à " + partPath);
					}
					
				}
				else if (partPath.equals(""))
				{
					// ps.println("2 Il semblerait que 2 '/' soient côte à côte.");
					newCurrentFile = null;
					// $$ rep2sent = true;
				}
				else {
					// Vérifie pour chaque enfant du répertoire courant ...
					for(File unEnfant : CommandExecutor.currentFile.listFiles())
					{
						// $$ System.out.println("NAME (" + unEnfant.getName() + ") / s (" + partPath + ") : " + (unEnfant.getName() == partPath) + " /// DIR : " + (unEnfant.isDirectory()));
						// ... si le nom correspond à partPath et si il est un dossier => vrai = newCurrentFile
						if (unEnfant.getName().equals(partPath) && unEnfant.isDirectory())
						{
							// $$ System.out.println(unEnfant.getAbsolutePath());
							newCurrentFile = new File(unEnfant.getAbsolutePath());
						}
					}
					// $$ System.out.println("1 .2 Accès à " + partPath);
				}
				
				
				
				// $$ System.out.println("VALEUR CURRENT FILE : " + (newCurrentFile == null));
				
				
				// Si newCurrentFile n'est pas défini, envoi d'un message d'erreur et arrêt de la boucle for.
				if (newCurrentFile == (null))
				{
					ps.println("2 Le répertoire indiqué n'existe pas Ou vous n'y avez pas accès. Veuillez entrer un autre chemin.");
					rep2sent = true;
					break;
				}
				// Sinon le répertoire courant est mis à jour.
				else
				{
					CommandExecutor.currentFile = newCurrentFile;
					ps.println("1 Répertoire courant modifié.");
				}
				
				// $$ System.out.println(CommandExecutor.currentFile.getAbsoluteFile());
				
			}
			// $$ System.out.println("\nFIN");
			
			if (!rep2sent)
			{				
				ps.println("0 Fin du listage");
			}
			
		}
		

		
	}
	
	

}
